<?php
namespace FlyingPress;

class Settings
{
  public static $menu_icon = 'data:image/svg+xml;base64,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';

  public static function init()
  {
    // Register settings menu
    add_action('admin_menu', ['FlyingPress\Settings', 'register_settings_menu']);
  }

  public static function register_settings_menu()
  {
    $menu = add_menu_page(
      'FlyingPress',
      'FlyingPress',
      'manage_options',
      'flying-press',
      ['FlyingPress\Settings', 'flying_press_front_end'],
      self::$menu_icon,
      '81'
    );

    // A kind of hack to inject JS only in the page we need
    add_action('admin_print_scripts-' . $menu, ['FlyingPress\Settings', 'inject_js']);
  }

  public static function inject_js()
  {
    wp_enqueue_script(
      'flying_press_admin_vuejs',
      FLYING_PRESS_PLUGIN_URL . 'assets/app.js',
      [],
      FLYING_PRESS_VERSION,
      true
    );
  }

  public static function flying_press_front_end()
  {
    $config = json_encode(Config::$config);
    $cached_pages = Cache::get_cached_pages_count();
    $version = 'v' . FLYING_PRESS_VERSION;
    echo "<script>window.flying_press={config:$config,cached_pages:$cached_pages,version:'$version'}</script>";
    echo '<div id="app"></div>';
  }
}
